--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A reference is a sort of container structure for objects. It holds a base object, as well as various variables associated with that object that make it unique.
--- 
--- For example, many doors may share the same base object. However, each door reference might have a different owner, different lock/trap statuses, etc. that make the object unique.
--- @class tes3reference : tes3object, tes3baseObject
--- @field activationReference tes3reference The current reference, if any, that this reference will activate.
--- @field animationData tes3animationData|nil *Read-only*. Access to the reference's animation data, if available. Typically this is only available on NPC or creature references.
--- @field attachments table<string, tes3bodyPartManager|tes3itemData|tes3lightNode|tes3lockNode|tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer|tes3reference|tes3travelDestinationNode|tes3animationData> *Read-only*. A table with friendly named access to all supported attachments. See the table below for available keys in this table.
--- 
--- Key               | Attachment type | Description
--- ----------------- | --------------- | -----------
--- actor             | [tes3mobileActor](https://mwse.github.io/MWSE/types/tes3mobileActor/) | The associated mobile object, if applicable.
--- animation         | [tes3animationData](https://mwse.github.io/MWSE/types/tes3animationData/) |
--- bodyPartManager   | [tes3bodyPartManager](https://mwse.github.io/MWSE/types/tes3bodyPartManager/) |
--- leveledBase       | [tes3reference](https://mwse.github.io/MWSE/types/tes3reference/) |
--- light             | [tes3lightNode](https://mwse.github.io/MWSE/types/tes3lightNode/) | The dynamic light attachment.
--- lock              | [tes3lockNode](https://mwse.github.io/MWSE/types/tes3lockNode/) | Only present on locked containers or doors.
--- travelDestination | [tes3travelDestinationNode](https://mwse.github.io/MWSE/types/tes3travelDestinationNode/) | Only present on teleport doors.
--- variables         | [tes3itemData](https://mwse.github.io/MWSE/types/tes3itemData/) | Only present on items when needed e.g. the item is fully repaired.
--- 
--- 
--- ```lua
--- -- Accessing the attached tes3animationData
--- local animData = myRef.attachments.animation
--- ```
--- 
--- @field baseObject tes3activator|tes3alchemy|tes3apparatus|tes3armor|tes3bodyPart|tes3book|tes3clothing|tes3container|tes3containerInstance|tes3creature|tes3creatureInstance|tes3door|tes3ingredient|tes3leveledCreature|tes3leveledItem|tes3light|tes3lockpick|tes3misc|tes3npc|tes3npcInstance|tes3physicalObject|tes3probe|tes3repairTool|tes3static|tes3weapon *Read-only*. This is similar to the object field, but is guaranteed to provide the base-most object. If object is an actor clone, the base actor will be given instead.
--- @field bodyPartManager tes3bodyPartManager|nil *Read-only*. Access to the reference's body part manager, if available. Typically this is only available on NPC references.
--- @field cell tes3cell *Read-only*. The cell that the reference is currently in.
--- @field context tes3scriptContext *Read-only*. Access to the script context for this reference and its associated script.
--- @field data table A generic lua table that data can be written to, and synced to/from the save. All information stored must be valid for serialization to json. For item references, this is the same table as on the `tes3itemData` structure. To store data that doesn't get serialized to/from the save, use `tempData`.
--- 
--- There is a guide available [here](https://mwse.github.io/MWSE/guides/storing-data/) on using this table.
--- @field destination tes3travelDestinationNode|nil *Read-only*. Returns the travel destination node for this reference, or `nil`. This can be used to determine where a given door links to.
--- @field facing number Convenient access to the z-component of the reference's orientation in range of [-PI, PI] for actors and [0, 2PI] radians for all the other references. The North is facing of 0. Setting the facing sets the reference as modified.
--- @field forwardDirection tes3vector3 *Read-only*. The normalized forward or Y direction vector of the reference.
--- @field hasNoCollision boolean Sets the no-collision flag on this reference, and recalculates collision groups. Use the [`setNoCollisionFlag()`](https://mwse.github.io/MWSE/types/tes3reference/?h=setnocollisionflag#setnocollisionflag) function to manage collision group recalculation instead.
--- @field isDead boolean|nil *Read-only*. Returns `true` if the object is dead, `false` if they are alive, or `nil` if that couldn't be determined.
--- @field isEmpty boolean Friendly access onto the reference's empty inventory flag.
--- @field isLeveledSpawn boolean *Read-only*. If true, this reference was created as a result of a leveled spawn.
--- @field isRespawn boolean *Read-only*. If true, the references respawn flag is set.
--- @field itemData tes3itemData Gets or sets the attached `itemData` for this reference. If set to `nil`, the item data will be unhooked but not deleted.
--- @field leveledBaseReference tes3reference|nil *Read-only*. If this reference is a leveled spawn, this is the leveled creature spawn reference. If this reference wasn't the result of a leveled spawn, the value is `nil`.
--- @field light niPointLight|niSpotLight *Read-only*. Direct access to the scene graph light, if a dynamic light is set.
--- @field lockNode tes3lockNode|nil *Read-only*. Quick access to the reference's lock node, if any. Doors or containers that aren't locked nor trapped have this property set to `nil`.
--- @field mesh string The path to the object's mesh.
--- @field mobile tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer|tes3mobilePlayer|tes3mobileProjectile|tes3mobileSpellProjectile|tes3mobileSpellProjectile|nil *Read-only*. Access to the attached mobile object, if applicable.
--- @field nextNode tes3reference *Read-only*. The next reference in the parent reference list.
--- @field nodeData tes3reference *Read-only*. Redundant access to this object, for iterating over a tes3referenceList.
--- @field object tes3activator|tes3alchemy|tes3apparatus|tes3armor|tes3bodyPart|tes3book|tes3clothing|tes3container|tes3containerInstance|tes3creature|tes3creatureInstance|tes3door|tes3ingredient|tes3leveledCreature|tes3leveledItem|tes3light|tes3lockpick|tes3misc|tes3npc|tes3npcInstance|tes3physicalObject|tes3probe|tes3repairTool|tes3static|tes3weapon *Read-only*. The object that the reference is for, such as a weapon, armor, or actor.
--- @field orientation tes3vector3 Access to the reference's orientation, in XYZ Euler angles in radians in [0, 2 PI] except for actors. For actors, the Z angle is in range [-PI, PI] radians. Changing the orientation marks the reference as modified.
--- @field position tes3vector3 Access to the reference's position. Setting the position sets the reference as modified.
--- 
--- For actors, the axes are:
--- 
---  - X right - left(+)
---  - Y front - back(+)
---  - Z down  - up(+)
--- 
--- @field previousNode tes3reference *Read-only*. The previous reference in the parent reference list.
--- @field rightDirection tes3vector3 *Read-only*. The normalized right or X direction vector of the reference.
--- @field sceneNode niBSAnimationNode|niBSParticleNode|niBillboardNode|niCollisionSwitch|niNode|niSortAdjustNode|niSwitchNode|nil *Read-only*. The scene graph node that the reference uses for rendering.
--- @field sourceFormId number No description yet available.
--- @field sourceModId number No description yet available.
--- @field stackSize number Access to the size of a stack, if the reference represents one or more items.
--- @field startingOrientation tes3vector3 *Read-only*. Access to the reference's original orientation. Note that this value is invalid for NPCs and creatures.
--- @field startingPosition tes3vector3 *Read-only*. Access to the reference's original position. Note that this value is invalid for NPCs and creatures.
--- @field supportsLuaData boolean If true, this reference can store temporary or persistent lua data.
--- @field targetFormId number No description yet available.
--- @field targetModId number No description yet available.
--- @field tempData table As with the `data` field, a generic lua table that data can be written to. No information in this table will persist into saves. For item references, this is the same table as on the `tes3itemData` structure.
--- 
--- There is a guide available [here](https://mwse.github.io/MWSE/guides/storing-data/) on using this table.
--- @field upDirection tes3vector3 *Read-only*. The normalized up or Z direction vector of the reference.
tes3reference = {}

--- Causes this reference to activate another. This will lead them to go through doors, pick up items, etc.
--- @param reference tes3reference The other reference to activate.
function tes3reference:activate(reference) end

--- Unsets a bit in the reference's action data attachment
--- @param flagIndex tes3.actionFlag The action flag to clear. Maps to values in [`tes3.actionFlag`](https://mwse.github.io/MWSE/references/action-flags/) namespace.
function tes3reference:clearActionFlag(flagIndex) end

--- Clones a reference for a base actor into a reference to an instance of that actor. For example, this will force a container to resolve its leveled items and have its own unique inventory. Also, marks the new cloned reference as modified.
--- @return boolean cloned Returns `true` if the reference was successfully cloned. Returns `false` if the reference was already cloned or can't be cloned.
function tes3reference:clone() end

--- Disables the reference, removes all its attachments, resets its scale, marks it as modified, and sets the reference to be deleted, trigerring `referenceDeactivated` event.
function tes3reference:delete() end

--- Deletes the dynamic light attachment, if it exists. This will automatically detach the dynamic light from affected nodes.
--- @param removeLightFromParent? boolean *Default*: `false`. If `true`, the dynamic light is removed from its parent node as well.
function tes3reference:deleteDynamicLightAttachment(removeLightFromParent) end

--- Removes the dynamic light from any affected scene graph nodes, but will not delete the associated attachment.
function tes3reference:detachDynamicLightFromAffectedNodes() end

--- Hides the reference, detaches all dynamic lights and sounds, and stops any mobile simulation. Sets the reference as modified implicitly.
--- @return boolean success If `true`, the reference was successfully disabled.
function tes3reference:disable() end

--- Shows the reference, reattaches all dynamic lights and sounds, and restarts any mobile simulation if the player is close enough. Sets the reference as modified implicitly.
--- @return boolean success If `true`, the reference was successfully enabled.
function tes3reference:enable() end

--- Calculates the angle from this reference's current facing to the target reference.
--- @param reference tes3reference The reference to calculate the angle to.
--- @return number angle The angle to the given reference in radians.
function tes3reference:getAngleTo(reference) end

--- Fetches the dynamic light attachment.
--- @return tes3lightNode result No description yet available.
function tes3reference:getAttachedDynamicLight() end

--- Fetches the dynamic light attachment. If there isn't one, a new one will be created with the given light and value.
--- 
--- If no light is supplied as an argument, a point light of radius 512 will be automatically created.
--- 
--- If the light is not attached to any part of the scene graph yet, the point light will be placed as a child of the "attachLight" subnode of the model, or a child of the model if "attachLight" is not found.
--- @param light? niPointLight|niSpotLight *Optional*. No description yet available.
--- @param phase? number *Optional*. No description yet available.
--- @return tes3lightNode result No description yet available.
function tes3reference:getOrCreateAttachedDynamicLight(light, phase) end

--- A function that tells the game that an inventory has been closed, if you are simulating inventory operations. It has the capability of un-cloning an inventory if it has not been modified. Typically not used outside of specific purposes.
--- @return boolean result No description yet available.
function tes3reference:onCloseInventory() end

--- Sets a bit in the reference's action data attachment.
--- @param flagIndex tes3.actionFlag The action flag to clear. Maps to values in [`tes3.actionFlag`](https://mwse.github.io/MWSE/references/action-flags/) namespace.
function tes3reference:setActionFlag(flagIndex) end

--- Sets the dynamic lighting state of the reference using the global data handler.
function tes3reference:setDynamicLighting() end

--- Sets if this reference has active collision. This is preferable to changing the `hasNoCollision` property, if you are manipulating multiple objects at once and do not want to constantly recalculate collision groups.
--- @param hasNoCollision boolean If `true`, the reference no longer has collision.
--- @param updateCollisions? boolean *Default*: `true`. If `true`, collision groups for the active cells are recalculated.
function tes3reference:setNoCollisionFlag(hasNoCollision, updateCollisions) end

--- Returns the flag's value in the reference's action data attachment.
--- @param flagIndex tes3.actionFlag The action flag to test. Maps to values in [`tes3.actionFlag`](https://mwse.github.io/MWSE/references/action-flags/) namespace.
--- @return boolean result No description yet available.
function tes3reference:testActionFlag(flagIndex) end

--- Causes the reference, if of an actor, to update the reference's bodyparts with the currently equipped ones.
function tes3reference:updateEquipment() end

--- Updates the lighting of the reference using the global data handler.
function tes3reference:updateLighting() end

--- Updates the reference's local rotation matrix, propagates position changes to the scene graph, and sets the reference's modified flag. You need to call this if the orientation or position was manually modified.
function tes3reference:updateSceneGraph() end

